<?php
  $Seccion      = 'Finanzas';
  $SubSeccion   = 'Facturacion';
  $NameSec      = 'Facturar';
  $NameSin      = 'Facturar';
  $SecLine      = array('Finanzas', 'Facturación', 'Facturar');
  $Position   = '../../../';
  require_once($Position.'config/config.php');
  require_once($Position.'config/conexion.php');
  require_once($Position.'config/user.php');
  require_once($Position.'funciones/acces.php');
  require_once($Position.'funciones/logout.php');
  require_once($Position.'funciones/funciones.php');

  $url = 'cancelarsave.php';
  $data = array('key1' => 'value1', 'key2' => 'value2');

  //Cancelar Factura
  if( $_POST[CancelFac] == 'Ok' ){

    //Plataforma de Salida
    if( $PlataformaFac[Id] ){
      require_once('cancelarfactura.php');
    }
    //End Plataforma de Salida
  }
  //End Cancelar Factura

  //Factura
  $Query = "
    SELECT
      fac.Id,
      fac.Fk_Cuenta,
      fac.Fecha, fac.RfcEmisor, fac.Emisor, fac.RfcReceptor, fac.Receptor,
      fac.Subtotal, fac.Impuesto, fac.Total,
      fac.Serie, fac.Folio, fac.IdFac, fac.Uuid, fac.Moneda,
      fac.Cancelada, fac.FechaCancelacion,
      fo.Clave AS FormaPagoClave, fo.Forma AS FormaPago,
      me.Clave AS MetodoPagoClave, me.Metodo AS MetodoPago,
      tip.Clave AS TipoClave, tip.Tipo,
      uso.Clave AS UsoClave, uso.Uso
    FROM Facturas fac
    LEFT JOIN FacturasFormasPagos fo ON fo.Clave = fac.Fk_FormaPago
    LEFT JOIN FacturasMetodosPagos me ON me.Clave = fac.Fk_MetodoPago
    LEFT JOIN FacturasTipos tip ON tip.Id = fac.Fk_Tipo
    LEFT JOIN FacturasUsos uso ON uso.Id = fac.Fk_Uso
    WHERE fac.Id = '$_GET[Id]'
      AND fac.RfcEmisor = '$PerfilSel[Rfc]'
  ";
  $Result = mysqli_query($mysqli, $Query);
  $Fac = mysqli_fetch_assoc($Result);

  if( $Fac[Id] ){  }else{
    echo '<script type="text/javascript">document.location.href="../"</script>';
  }

?>

<!DOCTYPE html>
<html lang="en">

<?php require_once($Position.'head.php'); ?>

<body class="fix-sidebar fix-header card-no-border">
    <!-- ============================================================== -->
    <!-- Preloader - style you can find in spinners.css -->
    <!-- ============================================================== -->
    <div class="preloader">
        <svg class="circular" viewBox="25 25 50 50">
            <circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10" /> </svg>
    </div>
    <!-- ============================================================== -->
    <!-- Main wrapper - style you can find in pages.scss -->
    <!-- ============================================================== -->
    <div id="main-wrapper">
        <?php require_once($Position.'header.php'); ?>
        <?php require_once($Position.'menu.php'); ?>

        <!-- ============================================================== -->
        <!-- Page wrapper  -->
        <!-- ============================================================== -->
        <div class="page-wrapper">
            <!-- ============================================================== -->
            <!-- Container fluid  -->
            <!-- ============================================================== -->
            <div class="container-fluid">
              <form method="post" enctype="multipart/form-data" data-validate="parsley" role="form" id="FormPer">
                <!-- ============================================================== -->
                <!-- Bread crumb and right sidebar toggle -->
                <!-- ============================================================== -->
                <div class="row page-titles page-titles-fixed">

                    <?php require_once($Position.'title.php'); ?>

                    <!-- Botones -->
                    <div class="col-md-7 align-self-center text-right">
                      <div class="btn-group" role="group" aria-label="Basic example">

                        <?php if( $Fac[Cancelada] == 0 ){ ?>
                          <!-- Btn Cancelar Factura -->
                          <button
                            data-toggle="modal"
                            data-target="#ModalCancelar"
                            type="button"
                            class="btn btn-sm btn-secondary"
                          >
                            Cancelar Factura <i class="fa fa-times m-l-10 text-danger"></i>
                          </button>
                          <!-- End Btn Cancelar Factura -->
                        <?php } ?>

                        <!-- Btn Pdf -->
                        <button
                          type="button"
                          class="btn btn-sm btn-secondary"
                          onclick="window.open('../pdf?Id=<?php echo $Fac['Id']; ?>')"
                        >
                          Descargar PDF <i class="fa fa-file m-l-10"></i>
                        </button>
                        <!-- End Btn Pdf -->

                        <!-- Btn Descargar Xml -->
                        <button
                          type="button"
                          class="btn btn-sm btn-secondary"
                          onclick="window.open('../xml?Id=<?php echo $Fac['Id']; ?>')"
                        >
                          Descargar XML <i class="fa fa-file m-l-10"></i>
                        </button>
                        <!-- End Btn Descargar Xml -->

                        <!-- Input Id -->
                        <input
                          type="hidden"
                          name="Id"
                          value="<?php echo $Pro['Id']; ?>"
                        >
                        <!-- End Input Id -->

                        <!-- Btn Mail -->
                        <button
                          type="button"
                          class="btn btn-sm btn-secondary"
                          data-toggle="modal"
                          data-target="#Mailk"
                        >
                          Mail <i class="fa fa-envelope m-l-10"></i>
                        </button>
                        <!-- End Btn Mail -->

                        <!-- Btn Regresar -->
                        <button
                          type="button"
                          class="btn btn-sm btn-secondary"
                          onclick="window.location.href='../'"
                        >
                          Regresar <i class="fa fa-arrow-left m-l-10"></i>
                        </button>
                        <!-- End Btn Regresar -->

                      </div>

                      <!-- Modal Wait -->
                      <div id="WaitModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-danger">
                          <div class="modal-content">
                            <div class="modal-body">
                              <h5>Por favor espera esto puede demorar un tiempo.</strong></h5>

                            </div>
                          </div>
                          <!-- /.modal-content -->
                        </div>
                        <!-- /.modal-dialog -->

                      </div>
                      <!-- End Modal Wait -->

                    </div>
                    <!-- End Botones -->

                </div>
                <!-- ============================================================== -->
                <!-- End Bread crumb and right sidebar toggle -->
                <!-- ============================================================== -->
                <!-- ============================================================== -->
                <!-- Page Content -->
                <!-- ============================================================== -->
                <div class="row inner-fixed-content">
                  <div class="col-12">

                    <?php /*if( $Save == 'Ok' || $_GET['New'] == Ok ){ ?>
                      <!-- Alerta Save -->
                      <div class="alert alert-success"> <i class="fa fa-check m-r-10"></i> Guardado !
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close"> <span aria-hidden="true">×</span> </button>
                      </div>
                      <!-- End Alerta Save -->
                    <?php }*/ ?>

                    <?php if( $ErrorTimbrado == 'Ok' ){ ?>
                      <!-- Alerta de Error de Timbrado -->
                      <div class="alert alert-danger">
                        <h3>¡Error de Cancelado!</h3>
                        <p>
                          <?php echo $MensajeErr; ?>
                        </p>
                      </div>
                      <!-- End Alerta de Error de Timbrado -->
                    <?php } ?>

                    <!-- Card -->
                    <div class="card">
                      <div class="card-body">
                        <div class="row">
                          <div class="col-sm-6">
                            <h4 class="card-title">Datos de Factura</h4>
                            <h6 class="card-subtitle">Factura</h6>
                          </div>
                          <div class="col-sm-6 text-right">
                            <?php if( $Fac[Cancelada] == '1' ){ ?>
                              <div>
                                <button class="btn btn-danger">Factura Cancelada</button>
                              </div>
                            <?php } ?>
                          </div>
                        </div>
                        <hr />

                        <div class="row">

                          <!-- Emisor -->
                            <div class="col-sm-6 form-group">
                              <label>Emisor</label>
                              <input class="form-control InputDis" readonly value="<?php echo $Fac[Emisor]; ?>" />
                            </div>
                          <!-- End Emisor -->

                          <!-- Emisor RFC -->
                            <div class="col-sm-6 form-group">
                              <label>Emisor RFC</label>
                              <input class="form-control InputDis" readonly value="<?php echo $Fac[RfcEmisor]; ?>" />
                            </div>
                          <!-- End Emisor RFC -->

                          <!-- Receptor -->
                            <div class="col-sm-6 form-group">
                              <label>Receptor</label>
                              <input class="form-control InputDis" readonly value="<?php echo $Fac[Receptor]; ?>" />
                            </div>
                          <!-- End Receptor -->

                          <!-- Receptor RFC -->
                            <div class="col-sm-6 form-group">
                              <label>Receptor RFC</label>
                              <input class="form-control InputDis" readonly value="<?php echo $Fac[RfcReceptor]; ?>" />
                            </div>
                          <!-- End Receptor RFC -->

                          <div class="col-sm-12">
                            <hr>
                          </div>

                          <!-- Subtotal -->
                            <div class="col-sm-4 form-group">
                              <label>Subtotal</label>
                              <input class="form-control InputDis text-right" readonly value="<?php echo number_format($Fac[Subtotal],2,'.',','); ?>" />
                            </div>
                          <!-- End Subtotal -->

                          <!-- Impuesto -->
                            <div class="col-sm-4 form-group">
                              <label>Impuesto</label>
                              <input class="form-control InputDis text-right" readonly value="<?php echo number_format($Fac[Impuesto],2,'.',','); ?>" />
                            </div>
                          <!-- End Impuesto -->

                          <!-- Total -->
                            <div class="col-sm-4 form-group">
                              <label>Total</label>
                              <input class="form-control InputDis text-right" readonly value="<?php echo number_format($Fac[Total],2,'.',','); ?>" />
                            </div>
                          <!-- End Total -->

                        </div>
                      </div>
                    </div>
                    <!-- End Card -->

                    <!-- Card -->
                    <div class="card">
                      <div class="card-body">
                        <div class="row">

                          <!-- Serie -->
                            <div class="col-sm-6 form-group">
                              <label>Serie</label>
                              <input class="form-control InputDis" readonly value="<?php echo $Fac[Serie]; ?>" />
                            </div>
                          <!-- End Serie -->

                          <!-- Folio -->
                            <div class="col-sm-6 form-group">
                              <label>Folio</label>
                              <input class="form-control InputDis" readonly value="<?php echo $Fac[Folio]; ?>" />
                            </div>
                          <!-- End Folio -->

                          <!-- Uuid -->
                            <div class="col-sm-6 form-group">
                              <label>Uuid</label>
                              <input class="form-control InputDis" readonly value="<?php echo $Fac[Uuid]; ?>" />
                            </div>
                          <!-- End Uuid -->

                          <!-- IdFac -->
                            <div class="col-sm-6 form-group">
                              <label>IdFac</label>
                              <input class="form-control InputDis" readonly value="<?php echo $Fac[IdFac]; ?>" />
                            </div>
                          <!-- End IdFac -->

                          <!-- Fecha -->
                            <div class="col-sm-6 form-group">
                              <label>Fecha</label>
                              <input class="form-control InputDis" readonly value="<?php echo CambioFechaInversa(date('Y-m-d', strtotime($Fac['Fecha']))); ?>" />
                            </div>
                          <!-- End Fecha -->

                          <!-- Hora -->
                            <div class="col-sm-6 form-group">
                              <label>Hora</label>
                              <input class="form-control InputDis" readonly value="<?php echo date('H:i:s', strtotime($Fac['Fecha'])); ?>" />
                            </div>
                          <!-- End Hora -->

                          <!-- Tipo de CFDI -->
                            <div class="col-sm-6 form-group">
                              <label>Tipo de CFDI</label>
                              <input class="form-control InputDis" readonly value="<?php echo $Fac[TipoClave].' - '.$Fac[Tipo]; ?>" />
                            </div>
                          <!-- Tipo de CFDI -->

                          <!-- Uso de CFDI -->
                            <div class="col-sm-6 form-group">
                              <label>Uso de CFDI</label>
                              <input class="form-control InputDis" readonly value="<?php echo $Fac[UsoClave].' - '.$Fac[Uso]; ?>" />
                            </div>
                          <!-- Uso de CFDI -->

                          <!-- Forma de Pago -->
                            <div class="col-sm-6 form-group">
                              <label>Forma de Pago</label>
                              <input class="form-control InputDis" readonly value="<?php echo $Fac[FormaPagoClave].' - '.$Fac[FormaPago]; ?>" />
                            </div>
                          <!-- Forma de Pago -->

                          <!-- Metodo de Pago -->
                            <div class="col-sm-6 form-group">
                              <label>Metodo de Pago</label>
                              <input class="form-control InputDis" readonly value="<?php echo $Fac[MetodoPagoClave].' - '.$Fac[MetodoPago]; ?>" />
                            </div>
                          <!-- Metodo de Pago -->

                        </div>

                      </div>
                    </div>
                    <!-- End Card -->

                    <!-- Card -->
                    <div class="card">
                      <div class="card-body">
                        <h4 class="card-title">Conceptos</h4>
                        <h6 class="card-subtitle"><?php echo $NameSec; ?></h6>
                        <hr />
                        <div class="">

                          <div class="table-responsive m-t-20">
                              <table id="example23" class="display nowrap table table-hover table-striped table-bordered" cellspacing="0" width="100%">
                                <thead>
                                  <tr>
                                    <th style="min-width: 200px;">Descripción</th>
                                    <th>Claves</th>
                                    <th>Precio</th>
                                    <th>Cant.</th>
                                    <th>Subtotal</th>
                                    <!--<th>Descuento</th>-->
                                    <th>Impuestos</th>
                                    <th>Total</th>
                                  </tr>
                                </thead>
                                <tbody class="Productos">
                                  <?php
                                  //Conceptos
                                  $Query = "
                                    SELECT
                                      con.Id, con.Descripcion, con.Clave, con.Unidad,
                                      con.Precio, con.Cantidad, con.Subtotal, con.Descuento,
                                      con.Iva, con.DescuentoTipo, con.Total
                                    FROM FacturasConceptos con
                                    WHERE con.Fk_Factura = '$Fac[Id]'
                                    ORDER BY con.Id ASC
                                  ";
                                  $Conceptos = $mysqli->query($Query);
                                  mysqli_data_seek($Conceptos, 0);
                                  while($Con = mysqli_fetch_array($Conceptos)) {
                                  ?>
                                    <tr class="Producto">
                                      <input type="hidden" name="ProductoPos[]" value="<?php echo $Pos; ?>" />
                                      <td>
                                        <?php echo $Con[Descripcion]; ?>
                                      </td>
                                      <td>
                                        <div class="text-center m-b-10">
                                          <label style="margin:0px; font-size:12px;">Clave</label>
                                          <input class="form-control text-center" readonly value="<?php echo $Con[Clave]; ?>" name="Producto[<?php echo $Pos; ?>][Clave]" />
                                        </div>
                                        <div class="text-center">
                                          <label style="margin:0px; font-size:12px;">Unidad</label>
                                          <input class="form-control text-center" readonly value="<?php echo $Con[Unidad]; ?>" name="Producto[<?php echo $Pos; ?>][Unidad]" />
                                        </div>
                                      </td>
                                      <td class="text-right">
                                        <?php echo number_format($Con[Precio],2,'.',','); ?>
                                      </td>
                                      <td class="text-center">
                                        <?php echo $Con[Cantidad]; ?>
                                      </td>
                                      <td class="text-right">
                                        <?php
                                          echo number_format($Con[Subtotal],2,'.',',');
                                          $Subtotal = $Subtotal + $Con[Subtotal];
                                        ?>
                                      </td>
                                      <!--<td>
                                        <select class="from-control chosen-select DescuentoTipo" name="Producto[<?php echo $Pos; ?>][DescuentoTipo]">
                                          <option value="">-</option>
                                          <option value="percentage">%</option>
                                          <option value="amount">$</option>
                                        </select>
                                        <input class="form-control font-size-13px Descuento" name="Producto[<?php echo $Pos; ?>][Descuento]" autocomplete="off" />
                                      </td>-->
                                      <td class="text-right">
                                        <?php
                                          echo number_format($Con[Iva],2,'.',',');
                                          $Impuestos = $Impuestos + $Con[Iva];
                                        ?>
                                      </td>
                                      <td>
                                        <div class="TotalProDiv text-right">
                                          <?php
                                            echo number_format($Con[Total],2,'.',',');
                                            $Total = $Total + $Con[Total];
                                          ?>
                                        </div>
                                        <input class="TotalPor" type="hidden" name="Producto[<?php echo $Pos; ?>][Total]" value="<?php echo $TotalPro; ?>" />
                                      </td>
                                    </tr>
                                  <?php } ?>
                                </tbody>
                                <tfoot>
                                  <tr>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th>Subtotal</th>
                                    <!--<th>Descuento</th>-->
                                    <th>Impuestos</th>
                                    <th>Total</th>
                                  </tr>
                                  <tr>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th class="text-right"><span id="ASubTotal"><?php echo number_format($Subtotal,2,'.',','); ?></span></th>
                                    <!--<th>Descuento</th>-->
                                    <th class="text-right"><span id="AImpuestos"><?php echo number_format($Impuestos,2,'.',','); ?></span></thth>
                                    <th class="text-right"><span id="ATotal"><?php $Total = $Subtotal + $Impuestos; echo number_format($Total,2,'.',','); ?></span></th>
                                  </tr>
                                </tfoot>
                              </table>

                        </div>

                      </div>
                    </div>
                    <!-- End Card -->

                  </div>
                </div>
              </form>

              <!-- ============================================================== -->
              <!-- End Page Content -->
              <!-- ============================================================== -->
            </div>
            <!-- ============================================================== -->
            <!-- End Container fluid  -->
            <!-- ============================================================== -->

            <?php require_once($Position.'footer.php'); ?>

            <?php if( $Fac[Cancelada] == 0 ){ ?>
              <!-- Modal Cancelar -->
              <div id="ModalCancelar" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
                <div class="modal-dialog">
                  <div class="modal-content">
                    <div class="modal-header">
                      <h4 class="modal-title" id="myModalLabel">Cancelar Factura</h4>
                      <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                    </div>
                    <div class="modal-body text-center">
                      <h5>Cancelar Factura</h5>
                      <p>
                        ¿Estas seguro de realizar esta acción?
                      </p>

                      <div class="form-group">
                        <h5>Motivo de la cancelación</h5>
                        <textarea class="form-control" id="ComCanFac"></textarea>
                      </div>

                    </div>
                    <div class="modal-footer">
                      <button type="button" class="btn btn-danger waves-effect BtnGoFac">Si. Cancelar Factura</button>
                      <button type="button" class="btn btn-secondary waves-effect" data-dismiss="modal">No</button>
                    </div>
                  </div>
                  <!-- /.modal-content -->
                </div>
                <!-- /.modal-dialog -->

              </div>
              <!-- End Modal Cancelar -->
              <form id="FormCancelFac" method="post">
                <input type="hidden" name="CancelFac" value="Ok">
                <input type="hidden" name="GetFac" value="No" />
                <input type="hidden" name="IdFa" value="<?php echo $Fac[Id]; ?>">
                <input type="hidden" name="IdFac" value="<?php echo $Fac[IdFac]; ?>">
                <input type="hidden" name="Comentario" id="ComInCanFac" value="" />
              </form>
            <?php } ?>

            <!-- Modal Envio Mail Factura -->
            <form class="Form-SendMail" method="post" data-validate="parsley" role="form">
              <div id="Mailk" class="modal fade Modal-SendMail" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
                <div class="modal-dialog">
                  <div class="modal-content">
                    <div class="modal-header">
                      <h4 class="modal-title" id="myModalLabel">Enviar Factura por correo</h4>
                      <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                    </div>
                    <div class="modal-body">

                      <?php
                      //Correo de Cliente
                      $Query = "
                        SELECT
                          cli.Id, cli.Rfc, cli.Email
                        FROM CatalogoClientes cli
                        WHERE cli.Rfc = '$Fac[RfcReceptor]'
                      ";
                      $Result = mysqli_query($mysqli, $Query);
                      $Correo    = mysqli_fetch_assoc($Result);
                      ?>

                      <!-- Correo -->
                      <div class="form-group">
                        <label>Correo</label>
                        <!-- Input Correo -->
                        <input
                          data-required="true"
                          data-type="email"
                          class="form-control"
                          autocomplete="off"
                          name="Correo"
                          value="<?php echo $Correo[Email]; ?>"
                        />
                        <!-- End Input Correo -->
                      </div>
                      <!-- End Correo -->

                      <!-- Mensaje -->
                      <div class="form-group">
                        <label>Mensaje</label>
                        <!-- Textarea Mensaje -->
                        <textarea
                          data-required="true"
                          name="Mensaje"
                          class="form-control"
                        ><?php ?></textarea>
                        <!-- End Textarea Mensaje -->
                      </div>
                      <!-- End Mensaje -->

                    </div>
                    <div class="modal-footer">

                      <!-- Btn Send Mail -->
                      <button
                        type="button"
                        class="btn btn-success BtnSendMail"
                      >
                        Enviar
                        <i class="fa fa-send m-l-10"></i>
                      </button>
                      <!-- End Btn Send Mail -->

                      <!-- Btn No -->
                      <button
                        type="button"
                        class="btn btn-secondary waves-effect"
                        data-dismiss="modal"
                      >
                        No
                      </button>
                      <!-- End Btn No -->

                      <input type="hidden" name="SendMail" value="Ok">
                      <input type="hidden" name="IdFac" value="<?php echo $Fac[Id]; ?>">
                    </div>
                  </div>
                  <!-- /.modal-content -->
                </div>
                <!-- /.modal-dialog -->

              </div>
            </form>
            <!-- End Modal Envio Mail Factura -->

        </div>
        <!-- ============================================================== -->
        <!-- End Page wrapper  -->
        <!-- ============================================================== -->
    </div>

    <?php require_once($Position.'scripts.php'); ?>
    <script>

      //Envio de Factura Mail
      $(document.body).on('click', '.BtnSendMail' ,function(){
        Formulario = $(this).parents('.Form-SendMail');
        Formulario.parsley().validate();
        if( Formulario.parsley().isValid() ){

          //Campos de Formulario
          var data = Formulario.serializeArray();
          //End Campos de Formulario

          //Hide Modal
          $('.Modal-SendMail').modal('hide');
          //End Hide Modal

          swal({
            imageUrl: '<?php echo $Position; ?>images/wait/wait1.gif',
            title: "Enviando Factura",
            text: "Espera por favor.",
            showConfirmButton: false
          });

          console.log('Aqui...');

          //Envia a Guardar Formulario
          $.post("../sendmail/index.php", data,
          function(datos){
            console.log('Envaido...');
            console.log(datos);
            var obj = JSON.parse(datos);
            console.log(datos);

            if( obj.Sended == 'Ok' ){

              swal({
                title: "Enviado",
                text: "Factura enviada.",
                showConfirmButton: true
              });

            }else{

              swal({
                title: "Error",
                text: "La factura no pudo ser enviada.",
                showConfirmButton: true
              });

            }

          });
          //End Envia a Guardar Formulario

        }
      });
      //End Envio de Factura Mail

      //Selección de Cliente
      $("#Cliente").change(function () {
        $("option:selected", this).each(function () {
          cli = $(this).val();
          //Actualiza Estados
          $.post("cliente.php", { cli: cli }, function(data){
            $('#DatosCliente').html(data);
            $(".chosen-select").chosen();
            $('.chosen-select').trigger("chosen:updated");
          });
        });
      });
      //End Selección de Cliente

      //Seleccion de Lugar de Expedición
      $("#Lugar").change(function () {
        $("option:selected", this).each(function () {
          val = $(this).val();
          //Actualiza Estados
          $.post("series.php", { val: val }, function(data){
            $('#Serie').html(data);
            $(".chosen-select").chosen();
            $('.chosen-select').trigger("chosen:updated");
          });
        });
      });
      //End Seleccion de Lugar de Expedición

      //Add Producto
      var pos = 0;
      $("#AddPro").click(function () {
          pos = pos + 1;
          pro = $('#Pro').val();
          if(pro){
            //Agrega Producto
            $.post("producto.php", { pro: pro, pos: pos }, function(data){
              $( ".Productos" ).append( data );
              //console.log(data);
              $(".chosen-select").chosen();
              $('.chosen-select').trigger("chosen:updated");

              //Suma los Totales
              var Total = 0;
              $('.TotalProDiv').each(function(){
    						Tot = parseFloat($(this).html());
    						Total = Total + Tot;
    					});
    					$('#ATotal').html(Total.toFixed(2));
              //End Suma los Totales

              //Suma de Impuestos
              var Total = 0;
              $('.ProductoImpuesto').each(function(){
    						Tot = parseFloat($(this).val());
    						Total = Total + Tot;
    					});
    					$('#AImpuestos').html(Total.toFixed(2));
              //End Suma de Impuestos

              //Suma los Subtotales
              var Total = 0;
              $('.Subtotal').each(function(){
    						Tot = parseFloat($(this).val());
    						Total = Total + Tot;
    					});
    					$('#ASubTotal').html(Total.toFixed(2));
              //End Suma los Subtotales

            });
          }
      });
      //End Add Producto

      //Quitar Producto
      $(document.body).on('click', '.DelPro' ,function(){
      	$(this).parents('.Producto').remove();
      });
      //End Quitar Producto

      //Ver Opciones Adicionales
      $(document.body).on('click', '.BtnOpcAdi' ,function(){
      	$('.OpcAdi').toggle();
      });
      //End Ver Opciones Adicionales

      //Edimción de Costos
      /*function toFixed(num) {
        num = num.toString(); //If it's not already a String
        num = num.slice(0, (num.indexOf("."))+3); //With 3 exposing the hundredths place
        return Number(num);
      }*/

        //Cambio de Precio
          $(document.body).on('change', '.Precio' ,function(){
            Producto   = $(this).parents('.Producto');
          	Precio     = $(this).val();
            Cantidad   = Producto.find('.Cantidad').val();
            Subtotal   = Cantidad * Precio;
            TotalPro   = Subtotal;
            Producto.find('.Subtotal').val(Subtotal);
            Cont = 0;

            //Descuento
            Descuento       = Producto.find('.Descuento').val();
            DescuentoTipo   = Producto.find('.DescuentoTipo').val();

            if( DescuentoTipo == 'amount' || DescuentoTipo == 'percentage' ){
              if( DescuentoTipo == 'amount' ){
                TotalPro = Subtotal - Descuento;
              }
              if( DescuentoTipo == 'percentage' ){
                Des = Descuento / 100;
                Descuento = Subtotal * Des;
                TotalPro = Subtotal - Descuento;
              }
            }
            //End Descuento

            //Calculo de Impuestos
            Producto.find('.Impuesto').each(function(index){
              console.log('Impuesto');
              Cont = Cont + 1;
              ProductoImpuesto = $(this).next('.ProductoImpuesto');
              Impuesto = $(this).val();
              Operador = $(this).data('operador');
              if( Operador == '+' ){
                Imp = Subtotal * Impuesto;
                //Imp = toFixed(Imp);
                TotalPro = TotalPro + Imp;
                Imp = Imp.toFixed(2);
                ProductoImpuesto.val(Imp);
                console.log(Impuesto + '- Imp: ' + Imp);
              }
              if( Operador == '-' ){
                Imp = Subtotal * Impuesto;
                Imp = Imp.toFixed(2);
                TotalPro = TotalPro - Imp;
                Imp = Imp.toFixed(2);
                ProductoImpuesto.val(Imp);
                console.log(Impuesto + '- Imp: ' + Imp);
              }
            });
            //End Calculo de Impuestos

            TotalPro = TotalPro.toFixed(2);
            console.log(TotalPro);
            Producto.find('.TotalPor').val(TotalPro);
            Producto.find('.TotalProDiv').html(TotalPro);

            //Suma los Totales
            var Total = 0;
            $('.TotalProDiv').each(function(){
              Tot = parseFloat($(this).html());
              Total = Total + Tot;
            });
            $('#ATotal').html(Total.toFixed(2));
            //End Suma los Totales

            //Suma de Impuestos
            var Total = 0;
            $('.ProductoImpuesto').each(function(){
              Tot = parseFloat($(this).val());
              Total = Total + Tot;
            });
            $('#AImpuestos').html(Total.toFixed(2));
            //End Suma de Impuestos

            //Suma los Subtotales
            var Total = 0;
            $('.Subtotal').each(function(){
              Tot = parseFloat($(this).val());
              Total = Total + Tot;
            });
            $('#ASubTotal').html(Total.toFixed(2));
            //End Suma los Subtotales

          });
        //End Cambio de Precio

        //Cambio de Cantidad
          $(document.body).on('change', '.Cantidad' ,function(){
            Producto   = $(this).parents('.Producto');
          	Cantidad   = $(this).val();
            Precio     = Producto.find('.Precio').val();
            Subtotal   = Cantidad * Precio;
            TotalPro   = Subtotal;
            Producto.find('.Subtotal').val(Subtotal);

            //Descuento
            Descuento       = Producto.find('.Descuento').val();
            DescuentoTipo   = Producto.find('.DescuentoTipo').val();

            if( DescuentoTipo == 'amount' || DescuentoTipo == 'percentage' ){
              if( DescuentoTipo == 'amount' ){
                TotalPro = Subtotal - Descuento;
              }
              if( DescuentoTipo == 'percentage' ){
                Des = Descuento / 100;
                Descuento = Subtotal * Des;
                TotalPro = Subtotal - Descuento;
              }
            }
            //End Descuento

            //Calculo de Impuestos
            Producto.find('.Impuesto').each(function(index){
              console.log('Impuesto');
              Cont = Cont + 1;
              ProductoImpuesto = $(this).next('.ProductoImpuesto');
              Impuesto = $(this).val();
              Operador = $(this).data('operador');
              if( Operador == '+' ){
                Imp = Subtotal * Impuesto;
                //Imp = toFixed(Imp);
                TotalPro = TotalPro + Imp;
                Imp = Imp.toFixed(2);
                ProductoImpuesto.val(Imp);
                console.log(Impuesto + '- Imp: ' + Imp);
              }
              if( Operador == '-' ){
                Imp = Subtotal * Impuesto;
                Imp = Imp.toFixed(2);
                TotalPro = TotalPro - Imp;
                Imp = Imp.toFixed(2);
                ProductoImpuesto.val(Imp);
                console.log(Impuesto + '- Imp: ' + Imp);
              }
            });
            //End Calculo de Impuestos

            TotalPro = TotalPro.toFixed(2);
            console.log(TotalPro);
            Producto.find('.TotalPor').val(TotalPro);
            Producto.find('.TotalProDiv').html(TotalPro);
          });
        //End Cambio de Cantidad

        //Cambio de Descuento
          $(document.body).on('change', '.Descuento' ,function(){
            console.log('------------------');
            Producto        = $(this).parents('.Producto');
            Subtotal        = Producto.find('.Subtotal').val();
            Descuento       = Producto.find('.Descuento').val();
            DescuentoTipo   = Producto.find('.DescuentoTipo').val();
            if( DescuentoTipo == 'amount' ){
              TotalPro = Subtotal - Descuento;
            }
            if( DescuentoTipo == 'percentage' ){
              Des = Descuento / 100;
              Descuento = Subtotal * Des;
              TotalPro = Subtotal - Descuento;
            }

            //Calculo de Impuestos
            Producto.find('.Impuesto').each(function(index){
              console.log('Impuesto');
              Cont = Cont + 1;
              ProductoImpuesto = $(this).next('.ProductoImpuesto');
              Impuesto = $(this).val();
              Operador = $(this).data('operador');
              if( Operador == '+' ){
                Imp = Subtotal * Impuesto;
                //Imp = toFixed(Imp);
                TotalPro = TotalPro + Imp;
                Imp = Imp.toFixed(2);
                ProductoImpuesto.val(Imp);
                console.log(Impuesto + '- Imp: ' + Imp);
              }
              if( Operador == '-' ){
                Imp = Subtotal * Impuesto;
                Imp = Imp.toFixed(2);
                TotalPro = TotalPro - Imp;
                Imp = Imp.toFixed(2);
                ProductoImpuesto.val(Imp);
                console.log(Impuesto + '- Imp: ' + Imp);
              }
            });
            //End Calculo de Impuestos

            TotalPro = TotalPro.toFixed(2);
            console.log(TotalPro);
            Producto.find('.TotalPor').val(TotalPro);
            Producto.find('.TotalProDiv').html(TotalPro);

          });
        //End Cambio de Descuento

      //End Edición de Costos

      //Validación de Formulario
      $(".BtnGoFac").click(function () {
        $('#ComInCanFac').val($('#ComCanFac').val());
        $('#ModalCancelar').modal('hide');
        swal({
          title: "¡Cancelando Factura!",
          text: "Esto puede demorar algun tiempo, por favor espera.",
          showConfirmButton: false
        });
        $('#FormCancelFac').submit();
      });
      //End Validación de Formulario

      //Cancelar Factura
      $(".BtnCanFac").click(function () {
        $('#ModalCancelar').modal('show');
      });
      //End Cancelar Factura

      //Respuesta de Cancelado de Factura
      <?php if( $CanStatus ){ ?>
        swal({
          title: "Cancelado de Factura",
          text: "<?php echo $CanMsg.'\n\n'.$CanMessage; ?>",
          showConfirmButton: true
        });
      <?php } ?>
      //End Respuesta de Cancelado de Factura

      //End Boton GoFac
      <?php if( $ErrorTimbrado == 'Ok' ){ ?>
        //Si hubo error al Timbrar
        $( document ).ready(function() {
          swal("Error de Cancelado", "", "error");
        });
        //End Si hubo error al Timbrar
      <?php } ?>

    </script>

</body>

</html>
